package gov.va.genisis2.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.genisis2.common.enums.RoleTypeEnum;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.service.impl.UserManagementService;

@Component
public class EhcacheHelper {

	private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheHelper.class);

	/** The user management service. */
	@Autowired
	private UserManagementService userManagementService;

	public void refreshUserData() throws GenisisServiceException {

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("#========== Refresh User Data from ehcache helper ==========#");
		}

		// Reset All Entries from Cache
		userManagementService.resetAllEntries(RoleTypeEnum.ADMIN.getId());
		userManagementService.resetAllEntries(RoleTypeEnum.DDM.getId());
		userManagementService.resetAllEntries(RoleTypeEnum.DSM.getId());

		// Update All Entries to Cache
		userManagementService.getUserDetailsByRoleTypeId(RoleTypeEnum.ADMIN.getId());
		userManagementService.getUserDetailsByRoleTypeId(RoleTypeEnum.DDM.getId());
		userManagementService.getUserDetailsByRoleTypeId(RoleTypeEnum.DSM.getId());
	}
}
